unit frm_Main;

//------------------------------------------------------------------------------
//     View Performance Counter and Categories
//     This sample is originally inspired from a MSDN Sample with some additional
//     features.
//
//     This code is released to the Delphi .NET community
//     I accept no liabilities for damage, use at your own risk.
//
//     Written by: Dave Bhatia, Tara Group, Inc. dbhatia@taragroup.com
//------------------------------------------------------------------------------

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Diagnostics;

type
  Tfrm_Main = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnGetCategories: System.Windows.Forms.Button;
    lstCategories: System.Windows.Forms.ListBox;
    lstCounters: System.Windows.Forms.ListBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnGetCategories_Click(sender: System.Object; e: System.EventArgs);
    procedure lstCategories_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
  private
    procedure ShowValues;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure Tfrm_Main.InitializeComponent;
begin
  Self.btnGetCategories := System.Windows.Forms.Button.Create;
  Self.lstCategories := System.Windows.Forms.ListBox.Create;
  Self.lstCounters := System.Windows.Forms.ListBox.Create;
  Self.SuspendLayout;
  // 
  // btnGetCategories
  // 
  Self.btnGetCategories.Location := System.Drawing.Point.Create(72, 16);
  Self.btnGetCategories.Name := 'btnGetCategories';
  Self.btnGetCategories.Size := System.Drawing.Size.Create(120, 23);
  Self.btnGetCategories.TabIndex := 0;
  Self.btnGetCategories.Text := 'View Categories';
  Include(Self.btnGetCategories.Click, Self.btnGetCategories_Click);
  // 
  // lstCategories
  // 
  Self.lstCategories.Location := System.Drawing.Point.Create(16, 56);
  Self.lstCategories.Name := 'lstCategories';
  Self.lstCategories.Size := System.Drawing.Size.Create(248, 316);
  Self.lstCategories.TabIndex := 1;
  Include(Self.lstCategories.SelectedIndexChanged, Self.lstCategories_SelectedIndexChanged);
  // 
  // lstCounters
  // 
  Self.lstCounters.Location := System.Drawing.Point.Create(272, 56);
  Self.lstCounters.Name := 'lstCounters';
  Self.lstCounters.Size := System.Drawing.Size.Create(264, 316);
  Self.lstCounters.TabIndex := 3;
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(552, 390);
  Self.Controls.Add(Self.lstCounters);
  Self.Controls.Add(Self.lstCategories);
  Self.Controls.Add(Self.btnGetCategories);
  Self.Name := 'TWinForm';
  Self.Text := 'Performance Category and Counters';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure Tfrm_Main.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor Tfrm_Main.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure Tfrm_Main.lstCategories_SelectedIndexChanged(sender: System.Object;
    e: System.EventArgs);
begin
  ShowValues;
end;

procedure Tfrm_Main.ShowValues;
var
  i,i2: Integer;
  mycat: System.Diagnostics.PerformanceCounterCategory;
  counters: System.Collections.ArrayList;
  instanceNames: array of string;
  lst : array of PerformanceCounter;
begin
  counters := System.Collections.ArrayList.Create;
  if (Self.lstCategories.SelectedIndex <> -1) then
  begin
    mycat := System.Diagnostics.PerformanceCounterCategory.Create(Self.lstCategories.SelectedItem.ToString);
    Self.lstCounters.Items.Clear;
    try
      instanceNames := mycat.GetInstanceNames;
      if (Length(instanceNames) = 0) then
       begin
        //lst := myCat.GetCounters

       // myCat.GetCounters;
        //counters.AddRange(mycat.GetCounters)
        lst := myCat.GetCounters;
        for i := 0 to Length(lst)-1 do counters.Add( lst[i].CounterName );
       end
      else
        begin
          i := 0;
          while (i < Length(instanceNames)) do
          begin
           lst := mycat.GetCounters(instanceNames[i]);
           for i2 := 0 to Length(lst)-1 do counters.Add( lst[i2].CounterName );
           inc(i);
          end; // while
         end; // if instancenames count > 0
         //
         for i:=0 to counters.Count-1 do
          begin
             lstCounters.Items.Add( counters[i]  );
          end;

      except
        on ex: System.Exception do
          MessageBox.Show(('Unable to list the counters for this category:'#10 + ex.Message));
      end;
  end;
end;


procedure Tfrm_Main.btnGetCategories_Click(sender: System.Object; e: System.EventArgs);
var
  i: Integer;
  myCat2: array of System.Diagnostics.PerformanceCounterCategory;
begin
  
  Self.lstCategories.Items.Clear;
  myCat2 := System.Diagnostics.PerformanceCounterCategory.GetCategories;
  i := 0;
  while (i < Length(myCat2)) do
  begin
    Self.lstCategories.Items.Add(myCat2[i].CategoryName);
    inc(i);
  end;
end;

end.
